package gov.va.genisis2.common.enums;

public enum WorkflowStatusEnum {

	DRAFT(1, "Draft"),
	SUBMITTED(2, "Submitted"),
	DENIED(3, "Denied"),
	RETURNED(4, "Returned"),
	SENT(5, "Sent"),
	UPDATE(6, "Update"),
	REQUESTACCEPTED(7, "RequestAccepted"),
	REQUESTNOTACCEPTED(8, "RequestNotAccepted"),
	RESULTSACCEPTED(9, "ResultsAccepted"),
	RESULTSNOTACCEPTED(10, "ResultsNotAccepted"),
	RESULTSDELIVERED(11, "ResultsDelivered"),
	CANCELLED(12, "Cancelled"),
	RETURNTODDM(13, "ReturnToDDM");

	private int id;
	private String desc;

	/**
	 * @param id
	 * @param desc
	 */
	private WorkflowStatusEnum(int id, String desc) {
		this.id = id;
		this.desc = desc;
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @return the desc
	 */
	public String getDesc() {
		return desc;
	}
	
	public static String getStatus(String operation) {
		String status = null;

		for (WorkflowStatusEnum workflowStatus : WorkflowStatusEnum.values()) {
			if (workflowStatus.getDesc().equalsIgnoreCase(operation)) {
				status = workflowStatus.getDesc();
				break;
			}
		}

		return status;
	}
}
